//********************************************************************************
//
//                       C O P Y R I G H T  (c) 2011
//                S O F T W A R E   T O O L B O X   I N C.
//                           All Rights Reserved.
//   ........................................................................
//   This sample code is provided by Software Toolbox solely to assist in
//   understanding the use of the SLIK OPC Data Access ActiveX Control. This
//   code is provided as-is and without warranty or support of any sort.
//
//********************************************************************************
//
//   Project:		SLIK-DA Interop Assembly
//
//   Description:   This sample server application is based on Software Toolbox's
//                  Simple Language Independent Toolkit for creating OPC Data
//                  Access servers (SLIK-DA).  It leverages the SLIK-DA Interop
//					Assembly that allows for the easy integration of this
//					ActiveX control into .NET applications.
//
//					This implementation replicates the VB Advanced OPC Server 
//					originally created to demonstrate various features of the 
//					SLIK-DA ActiveX Control in the VB6 environment.
//
//********************************************************************************
	
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace CSAdvancedServer
{
	/// <summary>
	/// Summary description for frmEditSP.
	/// </summary>
	public class frmEditSP : System.Windows.Forms.Form
	{
		public System.Windows.Forms.Label Label1;
		public System.Windows.Forms.TextBox txtSamplePeriod;
		public System.Windows.Forms.Button cmdOK;
		public System.Windows.Forms.Button cmdCancel;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public frmEditSP()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Label1 = new System.Windows.Forms.Label();
			this.txtSamplePeriod = new System.Windows.Forms.TextBox();
			this.cmdOK = new System.Windows.Forms.Button();
			this.cmdCancel = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// Label1
			// 
			this.Label1.BackColor = System.Drawing.SystemColors.Control;
			this.Label1.Cursor = System.Windows.Forms.Cursors.Default;
			this.Label1.Font = new System.Drawing.Font("Arial", 8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Label1.ForeColor = System.Drawing.SystemColors.ControlText;
			this.Label1.Location = new System.Drawing.Point(8, 16);
			this.Label1.Name = "Label1";
			this.Label1.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.Label1.Size = new System.Drawing.Size(273, 33);
			this.Label1.TabIndex = 3;
			this.Label1.Text = "Enter the sample period (milliseconds) for the calculation of server statistics.";
			// 
			// txtSamplePeriod
			// 
			this.txtSamplePeriod.AcceptsReturn = true;
			this.txtSamplePeriod.AutoSize = false;
			this.txtSamplePeriod.BackColor = System.Drawing.SystemColors.Window;
			this.txtSamplePeriod.Cursor = System.Windows.Forms.Cursors.IBeam;
			this.txtSamplePeriod.Font = new System.Drawing.Font("Arial", 8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtSamplePeriod.ForeColor = System.Drawing.SystemColors.WindowText;
			this.txtSamplePeriod.Location = new System.Drawing.Point(296, 24);
			this.txtSamplePeriod.MaxLength = 0;
			this.txtSamplePeriod.Name = "txtSamplePeriod";
			this.txtSamplePeriod.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.txtSamplePeriod.Size = new System.Drawing.Size(81, 19);
			this.txtSamplePeriod.TabIndex = 4;
			this.txtSamplePeriod.Text = "0";
			// 
			// cmdOK
			// 
			this.cmdOK.BackColor = System.Drawing.SystemColors.Control;
			this.cmdOK.Cursor = System.Windows.Forms.Cursors.Default;
			this.cmdOK.Font = new System.Drawing.Font("Arial", 8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.cmdOK.ForeColor = System.Drawing.SystemColors.ControlText;
			this.cmdOK.Location = new System.Drawing.Point(200, 64);
			this.cmdOK.Name = "cmdOK";
			this.cmdOK.RightToLeft = System.Windows.Forms.RightToLeft.Yes;
			this.cmdOK.Size = new System.Drawing.Size(81, 25);
			this.cmdOK.TabIndex = 0;
			this.cmdOK.Text = "OK";
			this.cmdOK.Click += new System.EventHandler(this.frmEditSP_CmdOK);
			// 
			// cmdCancel
			// 
			this.cmdCancel.BackColor = System.Drawing.SystemColors.Control;
			this.cmdCancel.Cursor = System.Windows.Forms.Cursors.Default;
			this.cmdCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.cmdCancel.Font = new System.Drawing.Font("Arial", 8F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.cmdCancel.ForeColor = System.Drawing.SystemColors.ControlText;
			this.cmdCancel.Location = new System.Drawing.Point(296, 64);
			this.cmdCancel.Name = "cmdCancel";
			this.cmdCancel.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.cmdCancel.Size = new System.Drawing.Size(81, 25);
			this.cmdCancel.TabIndex = 6;
			this.cmdCancel.Text = "Cancel";
			this.cmdCancel.Click += new System.EventHandler(this.frmEditSP_CmdCancel);
			// 
			// frmEditSP
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(400, 96);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.cmdCancel,
																		  this.cmdOK,
																		  this.txtSamplePeriod,
																		  this.Label1});
			this.Name = "frmEditSP";
			this.Text = "Edit Statistics Sample Period";
			this.Load += new System.EventHandler(this.frmEditSP_Load);
			this.ResumeLayout(false);

		}
		#endregion

		// Member variable used to transfer sample period between main menu and this dialog
		public int m_nStatSamplePeriod;

		private void frmEditSP_Load( System.Object sender , System.EventArgs eventArgs )
		{
			this.txtSamplePeriod.Text = "" + m_nStatSamplePeriod;
		}

		private void frmEditSP_CmdCancel( System.Object sender , System.EventArgs eventArgs )
		{
			this.Close();
		}

		private void frmEditSP_CmdOK( System.Object sender, System.EventArgs eventArgs )
		{
			int nTemp;
			nTemp = System.Convert.ToInt32( this.txtSamplePeriod.Text );

			if( ( nTemp <= CSlikUtil.c_nMaxStatSamplePeriod ) && 
				( nTemp >= CSlikUtil.c_nMinStatSamplePeriod ) )
			{
				m_nStatSamplePeriod = nTemp;
				this.Close();
			}
			else
			{
				MessageBox.Show( 
					"Enter Value Between " + CSlikUtil.c_nMinStatSamplePeriod + 
					" and " + CSlikUtil.c_nMaxStatSamplePeriod + ".",
					"Value Out Of Range",
					MessageBoxButtons.OK 
					);
			}
		}
	}
}
